/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.parser;

import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.parser.IPHPParseState;
import com.aptana.editor.php.internal.parser.PHPParseRootNode;
import com.aptana.editor.php.internal.parser.nodes.NodeBuilder;
import com.aptana.editor.php.internal.parser.nodes.NodeBuildingVisitor;
import com.aptana.editor.php.internal.parser.nodes.PHPBlockNode;
import com.aptana.editor.php.internal.parser.nodes.PHPCommentNode;
import com.aptana.editor.php.internal.typebinding.TypeBindingBuilder;
import com.aptana.parsing.AbstractParser;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.ASTParser;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class PHPParser
extends AbstractParser {
    protected static final ParseNode[] NO_CHILDREN = new ParseNode[0];
    private PHPVersion phpVersion;
    private IModule module;
    private ISourceModule sourceModule;
    private boolean parseHTML;
    private PHPParseRootNode latestValidNode;

    public PHPParser() {
        this(null);
    }

    public PHPParser(PHPVersion phpVersion) {
        this(phpVersion, true);
    }

    public PHPParser(PHPVersion phpVersion, boolean parseHTML) {
        this.phpVersion = phpVersion;
        this.parseHTML = parseHTML;
    }

    protected void parse(IParseState parseState, WorkingParseResult working) {
        String source = parseState.getSource();
        int startingOffset = parseState.getStartingOffset();
        PHPParseRootNode root = new PHPParseRootNode((Symbol[])NO_CHILDREN, startingOffset, startingOffset + source.length() - 1);
        Program program = null;
        if (parseState instanceof IPHPParseState) {
            IPHPParseState phpParseState = (IPHPParseState)parseState;
            this.phpVersion = phpParseState.getPHPVersion();
            IModule newModule = phpParseState.getModule();
            if (this.module != newModule) {
                this.module = newModule;
                this.sourceModule = phpParseState.getSourceModule();
                this.latestValidNode = null;
            }
            this.aboutToBeReconciled();
        }
        ASTParser parser = null;
        try {
            PHPVersion version = this.phpVersion == null ? PHPVersionProvider.getDefaultPHPVersion() : this.phpVersion;
            parser = ASTParser.newParser((Reader)new StringReader(source), (PHPVersion)version, (boolean)true, (ISourceModule)this.sourceModule);
            program = parser.createAST(null);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP parser error", (Throwable)e);
        }
        if (program != null) {
            this.processChildren(program, root, source);
        }
        boolean astHasErrors = false;
        if (program != null) {
            working.setParseResult((IParseRootNode)root);
            try {
                program.setSourceModule(ModelUtils.convertModule(this.module));
                AST ast = program.getAST();
                astHasErrors = ast.hasErrors();
                if (astHasErrors) {
                    working.setParseResult(null);
                }
                if (this.module != null) {
                    PHPGlobalIndexer.getInstance().processUnsavedModuleUpdate(program, this.module, source);
                }
                TypeBindingBuilder.buildBindings(program, source);
                ast.flushErrors();
            }
            catch (Throwable t) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP parser error", (Throwable)t);
            }
            this.reconciled(program, false, (IProgressMonitor)new NullProgressMonitor());
        } else {
            AST ast;
            if (parser != null && (ast = parser.getAST()) != null) {
                astHasErrors = ast.hasErrors();
                ast.flushErrors();
            }
            this.reconciled(null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        if (astHasErrors) {
            if (this.latestValidNode != null) {
                this.latestValidNode.setIsCached(true);
            }
            working.setParseResult((IParseRootNode)this.latestValidNode);
            return;
        }
        this.latestValidNode = root;
        working.setParseResult((IParseRootNode)root);
    }

    public IParseRootNode parse(InputStream source) {
        String input = IOUtil.read((InputStream)source);
        Program ast = this.parseAST(new StringReader(input));
        if (ast != null) {
            PHPParseRootNode root = new PHPParseRootNode((Symbol[])NO_CHILDREN, ast.getStart(), ast.getEnd());
            this.processChildren(ast, root, input);
            return root;
        }
        return new PHPParseRootNode((Symbol[])NO_CHILDREN, 0, 0);
    }

    public Program parseAST(Reader reader) {
        Program ast = null;
        try {
            PHPVersion version = this.phpVersion == null ? PHPVersionProvider.getDefaultPHPVersion() : this.phpVersion;
            ASTParser parser = ASTParser.newParser((Reader)reader, (PHPVersion)version, (boolean)true);
            ast = parser.createAST(null);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP parser error", (Throwable)e);
        }
        return ast;
    }

    private void aboutToBeReconciled() {
        PHPEplPlugin.getDefault().getASTProvider().aboutToBeReconciled(this.sourceModule);
    }

    private void reconciled(Program program, boolean forced, IProgressMonitor progressMonitor) {
        PHPEplPlugin.getDefault().getASTProvider().reconciled(program, this.sourceModule, progressMonitor);
    }

    private void processChildren(Program ast, ParseRootNode root, String source) {
        ArrayList<PHPCommentNode> commentNodes = new ArrayList<PHPCommentNode>();
        for (Comment c : ast.comments()) {
            commentNodes.add(new PHPCommentNode(c));
        }
        root.setCommentNodes(commentNodes.toArray(new IParseNode[commentNodes.size()]));
        NodeBuilder builderClient = new NodeBuilder(source, false, this.parseHTML);
        ast.accept((Visitor)new NodeBuildingVisitor(builderClient, source));
        PHPBlockNode nodes = builderClient.populateNodes();
        IParseNode[] iParseNodeArray = nodes.getChildren();
        int n = iParseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            root.addChild(child);
            ++n2;
        }
    }
}

